#define _GNU_SOURCE   /* needed to get snprintf prototype */
#include <stdio.h>
#include <panel.h>
#include <math.h>
#include <ctype.h>
#include <stdarg.h>
#include <string.h>
#include "UIcurses.h"
#include "global.h"
#include "movement.h"
#include "functions.h"

#define SEARCHSZ 13
#define DBOXCOL1 1
#define DBOXCOL2 21
#define DBOXCOL3 48
#define PRINTF_BUFFER 100


WINDOW *w1;   /* Header window showing filename, etc. */    
WINDOW *w2;   /* Main window showing offsets and data */ 
WINDOW *wh;   /* Help window */
WINDOW *wd;   /* Dialog window */

extern ctl c;



void quit_curses(PANEL *p1, PANEL *p2, PANEL *ph) {
	del_panel(p1);
	del_panel(p2);
	del_panel(ph);
	endwin();
	printf("\n");
	exit(0);
}



void print_databox(unsigned char *content) {
	unsigned char *NextByte;
	char next_item[5];  /* FIXME  magic number */
	int col, row;

	werase(w2);

	for(row=0; row < c.LinesPerDbox; row++) {
		/* Don't print addresses past the end of file */
		if (c.Offset + row*PER_LINE > c.filesize) break;
		/* Print the address */
		if (c.a_format) mvwprintw(w2, row, 0, "%05x: ", c.Offset + row*PER_LINE);
		else            mvwprintw(w2, row, 0, "%05d: ", c.Offset + row*PER_LINE);

		for(col=0; col < PER_LINE; col++) {
			/* Get the next byte in file */
			NextByte = content + c.Offset + row*PER_LINE + col;
			/* Get the ASCII to print*/
			toprint(*NextByte, next_item, 5);
			/* Don't print past the end of file */
			if (c.Offset + row*PER_LINE + col > c.filesize - 1) break;
			/* If we're printing the field under the cursor, highlight it */
			if ( c.Offset + PER_LINE*row + col == c.CursorOffset )
				wattron(w2, COLOR_PAIR(COLOR_GREEN));

			/* Print the data in either hex or decimal */
			if (c.d_format)
				mvwprintw(w2, row, A_FIELD_LNG + 4*col, "%02x", *NextByte);
			else
				mvwprintw(w2, row, A_FIELD_LNG + 4*col, "%02d", *NextByte);

			/* Print the ASCII */
			mvwprintw(w2, row, A_FIELD_LNG+1+4*PER_LINE + 4*col,"%02s",next_item);
			/* Turn highlight off */
			wattrset(w2, 0);
		}
	}
}



void print_headerbox(void) {
	werase(w1);
	wborder(w1, VLINE, VLINE, HLINE, HLINE, ULCORN, URCORN, BLCORN, BRCORN);
	UpdateControlStructure();
	HboxPrintf(1, DBOXCOL1, "File: %s", c.filename);
	HboxPrintf(2, DBOXCOL1, "y/x: %d,%d", c.y, c.x);

	if (c.a_format)
		HboxPrintf(1, DBOXCOL2, "Cursor Offset: %05x", c.CursorOffset);
	else
		HboxPrintf(1, DBOXCOL2, "Cursor Offset: %05d", c.CursorOffset);

	HboxPrintf(2, DBOXCOL2, "Filesize: %d  ", c.filesize);
	switch (c.mode) {
		case 0: strncpy(c.inputbox, "Command Mode",     IBOXSZ); break;
		case 1: strncpy(c.inputbox, "ASCII search: ",   IBOXSZ); break;
		case 2: strncpy(c.inputbox, "Hex search: ",     IBOXSZ); break;
		case 3: strncpy(c.inputbox, "Dec search: ",     IBOXSZ); break;
		case 4: strncpy(c.inputbox, "Str Replace Cell", IBOXSZ); break;
		case 5: strncpy(c.inputbox, "Hex Replace Cell", IBOXSZ); break;
		case 6: strncpy(c.inputbox, "Dec Replace Cell", IBOXSZ); break;
		case 7: strncpy(c.inputbox, "Str Replace Mode", IBOXSZ); break;
		case 8: strncpy(c.inputbox, "Hex Replace Mode", IBOXSZ); break;
		case 9: strncpy(c.inputbox, "Dec Replace Mode", IBOXSZ); break;
		case 99: /* do nothing */; break;
	}
	HboxPrintf(1, DBOXCOL3, "%s", c.inputbox);
	wnoutrefresh(w1);
	doupdate();
	getyx(w1, c.InputY, c.InputX);
}



void show_help(PANEL *p1, PANEL *p2, PANEL *ph) {
	WINDOW *wh = panel_window(ph);
	char ch;
	hide_panel(p1); hide_panel(p2); show_panel(ph);
	doupdate(); update_panels();
	ch = mvwgetch(wh, LINES-1, COLS-1);
	show_panel(p1); show_panel(p2); hide_panel(ph);
}



void create_help(PANEL *ph) {
WINDOW *wh = panel_window(ph);
int i=0, j=3;  /* j is an indent */

init_pair(COLOR_GREEN, COLOR_GREEN, COLOR_BLACK);
init_pair(COLOR_YELLOW, COLOR_YELLOW, COLOR_BLACK);

mvwprintw(wh, i, 32, "bed Help Screen");

wattron(wh, COLOR_PAIR(COLOR_YELLOW));
i += 2; mvwprintw(wh, i, 0, "Commands:");
wattron(wh, COLOR_PAIR(COLOR_GREEN));
mvwprintw(wh,++i,j,"q          Quit");
mvwprintw(wh,++i,j,"<F2>       Toggle data between decimal and hex");
mvwprintw(wh,++i,j,"<F3>       Toggle offsets between decimal and hex");
mvwprintw(wh,++i,j,"R          Replace mode (ESCAPE ends replace)      ");
mvwprintw(wh,++i,j,"r          Replace value of currently selected cell");

i += 2;
wattron(wh, COLOR_PAIR(COLOR_YELLOW));
mvwprintw(wh, i, 0, "Cursor and page movment:");
wattron(wh, COLOR_PAIR(COLOR_GREEN));
mvwprintw(wh,++i,j,"<Pgup>     Move the databox one page up.");
mvwprintw(wh,++i,j,"<Pgdown>   Move the databox one page down");
mvwprintw(wh,++i,j,"<Home>     Move cursor to the start of file");
mvwprintw(wh,++i,j,"<End>      Move cursor to the end of file");
mvwprintw(wh,++i,j,"G          Move cursor to the end of file");
mvwprintw(wh,++i,j,"0          Move cursor to the beginning of current line");
mvwprintw(wh,++i,j,"$          Move cursor to the end of line");

i += 2;
wattron(wh, COLOR_PAIR(COLOR_YELLOW));
mvwprintw(wh, i, 0, "Other:");
wattron(wh, COLOR_PAIR(COLOR_GREEN));
mvwprintw(wh,++i,j, "/          Perform search");
mvwprintw(wh,++i,j, "F1         Help screen");

mvwprintw(wh, 20, 27, "Press any key to continue");
wattroff(wh, COLOR_PAIR(COLOR_GREEN));
wattroff(wh, COLOR_PAIR(COLOR_YELLOW));
wnoutrefresh(wh);
doupdate();
}



void user_interface(unsigned char *contents) {
	PANEL  *p1, *p2, *ph, *pd;
	int i=0, input;
	int Number;
	int NumberString[80]; /* FIXME: magic number */
	
	initscr();
	if (has_colors()) {
		start_color();
		init_pair(COLOR_GREEN,   COLOR_GREEN,   COLOR_BLACK);
		init_pair(COLOR_YELLOW,    COLOR_YELLOW,    COLOR_BLACK);
	}
	nonl();              /* don't translate NL to CR/NL */
	cbreak();            /* input is uncooked           */
	noecho();            /* don't echo input            */	

	/* Create the windows */
	w1 = newwin(HBOX_LINES, COLS, 0, 0);
	w2 = newwin(LINES - HBOX_LINES, COLS, HBOX_LINES, 0);
	wh = newwin(0,0,0,0);                         /* The help screen */
	wd = newwin(5, 20, (LINES-5)/2, (COLS-20)/2); /* The dialog screen */
	if (w1==NULL || w2==NULL || wh==NULL)
		die(1, "Couldn't get a pointer to a WINDOW.\n");
	keypad(w1, TRUE);

	/* Turn the windows into panels */	
	pd = new_panel(wd);
	ph = new_panel(wh);
	p1 = new_panel(w1);
	p2 = new_panel(w2);
	if (p1==NULL || p2==NULL || ph==NULL)
		die(1, "Couldn't get a pointer to a PANEL.\n");
	werase(w1); werase(w2); werase(wh);
	create_help(ph);

	UpdateControlStructure();

	/* Main Event Loop */
	while ( 1 ) {
		UpdateControlStructure();
		print_headerbox();
		print_databox(contents);
		wnoutrefresh(w2);
		doupdate();
		
		HideCursor();

		/*  Allow a number argument to precede input, like 22G to jump to offset
		 *  22.  If input is a digit (except for a 0), keep reading until we get
		 *  a non-digit
		 */
		Number = 0;
		input = HboxGetInt(c.InputY, c.InputX);
		if (input=='#' || input=='%') {
			c.mode = 99; /* user defined (yes, it's a hack) */
			if (input=='#') strcpy(c.inputbox, "#");
			else            strcpy(c.inputbox, "%");
			print_headerbox();

			for(i=0; ; ++i) {
				NumberString[i] = HboxGetInt(c.InputY, c.InputX);
				if (NumberString[i] == ESCAPE)
					goto BEGINTEST;
				else if (NumberString[0]=='#' && isdigit(NumberString[i]))
					NumberString[i+1] = '\0';
				else if (NumberString[0]=='%' && isxdigit(NumberString[i]))
					NumberString[i+1] = '\0';
				else
					goto BEGINTEST;

				HboxPrintf(1, DBOXCOL3 + i, "%d", NumberString[i]);
			}
		}

		BEGINTEST:
		c.mode = 0;
		print_headerbox();
		if      (input == 'q')        { quit_curses(p1, p2, ph);   }
		else if (input == F1)         { show_help(p1,p2,ph);       }
		else if (input == F2)         { ToggleOffsetFormat();      }
		else if (input == F3)         { ToggleDataFormat();        }
		else if (input == '/')        { Search(contents);          }
		else if (input == KEY_HOME)   { GotoStartOfFile();         }
		else if (input == KEY_END)    { JumpToEndOfFile();         }
		else if (input == '0')        { MoveCursorToFrontOfLine(); }
		else if (input == '$')        { MoveCursorToEndOfLine();   }
		else if (input == KEY_UP)     { MoveCursorLineUp();        }
		else if (input == KEY_DOWN)   { MoveCursorLineDown();      }
		else if (input == KEY_LEFT)   { MoveCursorBackward();      }
		else if (input == KEY_RIGHT)  { MoveCursorForward();       }
		else if (input == KEY_NPAGE)  { JumpToNextPage();          }
		else if (input == KEY_PPAGE)  { JumpToPreviousPage();      }
		else if (input == KEY_END)    { JumpToEndOfFile();         }
		else if (input == 'r')        { ReplaceACell(contents);    }
		else if (input == 'R')        { ReplaceManyCells(contents);}
		else if (input == CTL_L)      { wrefresh(w1); wrefresh(w2);}

		if (input == 'G') {
			if (Number==0) {
				JumpToEndOfFile();
			} else {
				/* JumpToLineNumber(Number); FIXME */
			}
		}
		doupdate();
		i=0;
	}
}


void Search(unsigned char *contents)
{
	int ch;
	c.mode = (c.mode + 1) % 4;
	print_headerbox();

	ShowCursor();
	while(1) {
		ch = HboxGetInt(c.InputY, c.InputX);
		if (ch=='/' ) {
			c.mode = (c.mode + 1) % 4;
			print_headerbox();
		} else if (ch==NEWLINE || ch==ESCAPE) {
			c.mode = 0;
			break;
		}
		if (c.mode == 0) return;
	}
	/* Now we begin to read characters for the search */

	if      (c.mode==1) StringSearch();
	/* else if (c.SearchType==2) HexSearch();
	else                      DecSearch(); */
	HideCursor();
}


void StringSearch(void)
{
	char ToSearch[SEARCHSZ];
	int i, ch;

	for (i=0; i<SEARCHSZ; ++i) {
	/*	ch = GetChar();    FIXME */ 
		if (ch == ESCAPE) {
			c.mode=0;
			return;
		}
		if (ch == NEWLINE)
		if (isalnum(ch)) ToSearch[i] = ch;
	}
}



void HboxPrintf(int y, int x, char *fmt, ...)
{
	va_list arg_ptr;
	char *fmtptr, Target[PRINTF_BUFFER], *s;
	char *TargetPtr = Target;

	strcpy(Target, ""); /* make it a string */
	va_start(arg_ptr, fmt);

	/* Process fmt, character by character */
	for (fmtptr=fmt; *fmtptr; ++fmtptr) {
		if (*fmtptr != '%') {
			sprintf(TargetPtr, "%c", *fmtptr);
			++TargetPtr;
			continue;
		}

		switch(*++fmtptr) {
			case 's':
				for (s=va_arg(arg_ptr, char *); *s; s++) {
					sprintf(TargetPtr, "%c", *s);
					++TargetPtr;
				}
				break;
			case 'c':
				sprintf(TargetPtr, "%c", (char) va_arg(arg_ptr, int));
				++TargetPtr;
				break;
			case 'd':
				sprintf(TargetPtr, "%d", va_arg(arg_ptr, int));
				++TargetPtr;
				break;
		}
	}
	va_end(arg_ptr);
	mvwprintw(w1, y, x, "%s", Target);
}



void DboxPrintf(int y, int x, char *fmt, ...)
{
	va_list arg_ptr;
	char *fmtptr, Target[PRINTF_BUFFER], *s;
	char *TargetPtr = Target;

	strcpy(Target, ""); /* make it a string */
	va_start(arg_ptr, fmt);

	/* Process fmt, character by character */
	for (fmtptr=fmt; *fmtptr; ++fmtptr) {
		if (*fmtptr != '%') {
			sprintf(TargetPtr, "%c", *fmtptr);
			++TargetPtr;
			continue;
		}
		switch(*++fmtptr) {
			case 's':
				for (s=va_arg(arg_ptr, char *); *s; s++) {
					sprintf(TargetPtr, "%c", *s);
					++TargetPtr;
				}
				break;
			case 'c':
				sprintf(TargetPtr, "%c", (char) va_arg(arg_ptr, int));
				++TargetPtr;
				break;
			case 'd':
				sprintf(TargetPtr, "%d", va_arg(arg_ptr, int));
				++TargetPtr;
				break;
		}
	}
	va_end(arg_ptr);
	mvwprintw(w2, y, x, "%s", Target);
}


/* One liners to be ported to whatever interface is needed */

void HideCursor(void) { curs_set(0); }

void ShowCursor(void) { curs_set(1); }

char DboxGetChar(int y, int x) { return(mvwgetch(w2, y, x)); }

char HboxGetChar(int y, int x) { return(mvwgetch(w1, y, x)); }

int DboxGetInt(int y, int x) { return(mvwgetch(w2, y, x)); }

int HboxGetInt(int y, int x) { return(mvwgetch(w1, y, x)); }
