#define _GNU_SOURCE   /* needed to get snprintf prototype */
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include "global.h"
#include "movement.h"
#include "functions.h"
#include "UIcurses.h"
#define ESCAPE 27

extern ctl c;

/*
 *   Takes a decimal int arg (arg), load a string (str) to print in databox
 */
void toprint(int arg, char *str, int strsize) {
	if (arg == 0) {
		snprintf(str, strsize, "^1");
	} else if (arg >= 1 && arg <= 26) {
		snprintf(str, strsize, "^%c", arg+'A'-1);
	} else if (arg == 27) {
		snprintf(str, strsize, "esc");
	} else if (arg == 28) {
		snprintf(str, strsize, "^\\");
	} else if (arg == 29) {
		snprintf(str, strsize, "^]");
	} else if (arg == 30) {
		snprintf(str, strsize, "^=");
	} else if (arg == 31) {
		snprintf(str, strsize, "^-");
	} else if (arg >= 32 && arg <= 126) {   /* space to ~ */
		snprintf(str, strsize, "%c", arg);
	} else if (arg == 127) {
		snprintf(str, strsize, "del");
	} else {
		snprintf(str, strsize, "??");
	}
}




void StringFind(unsigned int *target, unsigned int n, unsigned int *content) {
	unsigned int i;

	/* Search from cursor position to end of file */
	for (i=c.CursorOffset; i<=c.filesize-n; ++i)
		if (! memcmp(target, &i, n)) JumpToOffset(i);

	/* Search from beginning of file to current cursor position */
	for (i=0; i<=c.CursorOffset; ++i)
		if (! memcmp(target, &i, n)) JumpToOffset(i);
}



void ToggleDataFormat(void)
{
	c.d_format = ++c.d_format % 2;
}



void ToggleOffsetFormat(void)
{
	c.a_format = ++c.a_format % 2;
}

int IsHexCharacter(unsigned char ch)
{
	ch = toupper(ch);
	if ((ch >= '0' && ch <= '9') || (ch >= 'A' && ch <= 'F'))
		return(1);
	else
		return(0);
}


void UpdateControlStructure(void)
{
	/* # of data lines needed to print whole file with PER_LINE elements/line. */
	c.tot_dlines = (int)ceil((float)c.filesize / (float)PER_LINE); /* check */

	c.LinesPerDbox = LINES - HBOX_LINES;
	c.CellsPerPage = PER_LINE * c.LinesPerDbox;
	c.LastOffset   = c.tot_dlines % c.LinesPerDbox;

	/* Address of last tp_addr: check */
	c.LastOffset = c.CellsPerPage * c.tot_dlines / c.LinesPerDbox;

	/* Last cursor position: check */
	c.last_x = c.filesize % PER_LINE - 1;
	c.last_y = ((c.tot_dlines-1)*PER_LINE - c.LastOffset) / PER_LINE;
	c.y = (c.CursorOffset - c.Offset) / PER_LINE;
	c.x = (c.CursorOffset - c.Offset) - c.y * PER_LINE;
}



int ConvertFromHex(unsigned char c)
{
	c = toupper(c);
	if   (c >= '0' && c <= '9') { return(c-'0'); }
	else                        { return(c-'A'+10); }
}




/*  This is just fucking sick.  Not only is this a hack, but I separated
 *  "replace" and "replace many".  Someone please shoot me now and put me
 *  out of my misery.  This will be changed.  I promise.
 */

void ReplaceManyCells(unsigned char *content)
{
	unsigned char ch1, ch2, ch3, EntryType;
	unsigned int i;
	unsigned char *targ;

	ShowCursor();
	HboxPrintf(1, 46, "%s", "(s)tr, (h)ex or (d)ec replace: ");
	do {
		EntryType = HboxGetChar(1, 77);
		if (EntryType == ESCAPE) { return; }
	} while (EntryType != 's' && EntryType != 'h' && EntryType != 'd');
	HideCursor();
	
	if      (EntryType == 's') c.mode = 7;
	else if (EntryType == 'h') c.mode = 8;
	else if (EntryType == 'd') c.mode = 9;
	print_headerbox();

	while(1) {
		targ = content + c.CursorOffset;

		if (EntryType=='s') {

			while (1) {
				ch1 = DboxGetChar(c.y, 4*c.x + A_FIELD_LNG);
				if      (ch1 == ESCAPE)  { goto FINIT; }
				else if (ch1 == NEWLINE) { goto FINIT; }
				else if (isalnum(ch1))   { break;      }
			}
			*targ = ch1;
			goto LOOP;

		} else if (EntryType=='d') {

			while (1) {
				ch1 = DboxGetChar(c.y, 4*c.x + A_FIELD_LNG);
				if      (ch1 == ESCAPE)  { goto FINIT; }
				else if (ch1 == NEWLINE) { goto FINIT; }
				else if (isdigit(ch1))   { break;      }
			}
			DboxPrintf(c.y, 4*c.x + A_FIELD_LNG, "%c", ch1);
			while (1) {
				ch2 = DboxGetChar(c.y, 4*c.x + A_FIELD_LNG + 1);
				if      (ch2 == ESCAPE)  { goto FINIT; }
				else if (isdigit(ch2))   { break;      }
				else if (ch2 == NEWLINE) { *targ = ch1-'0'; goto LOOP; }
			}
			DboxPrintf(c.y, 4*c.x + A_FIELD_LNG + 1, "%c", ch2);
			while (1) {
				ch3 = DboxGetChar(c.y, 4*c.x + A_FIELD_LNG + 2);
				if      (ch3==ESCAPE) {goto FINIT; }
				else if (isdigit(ch3)){break;      }
				else if (ch3==NEWLINE){*targ = (ch1-'0')*10 + ch2-'0'; goto LOOP; }
			}
			DboxPrintf(c.y, 4*c.x + A_FIELD_LNG + 2, "%c", ch3);
			i = (ch1-'0')*100 + (ch2-'0')*10 + ch3-'0';
			if (i < 256) *targ = i;
	
		} else if (EntryType == 'h') {
	
			while (1) {
				ch1 = DboxGetChar(c.y, 4*c.x + A_FIELD_LNG);
				if      (ch1 == ESCAPE)  { goto FINIT; }
				else if (ch1 == NEWLINE) { goto FINIT; }
				else if (isxdigit(ch1))  { break;    }
			}
			DboxPrintf(c.y, 4*c.x + A_FIELD_LNG, "%c", ch1);
			while (1) {
				ch2 = DboxGetChar(c.y, 4*c.x + A_FIELD_LNG + 1);
				if      (ch2 == ESCAPE)   { goto FINIT; }
				else if (isxdigit(ch2))   { break;      }
				else if (ch2 == NEWLINE)  { *targ = ConvertFromHex(ch1);goto LOOP; }
			}
			DboxPrintf(c.y, 4*c.x + A_FIELD_LNG + 2, "%c", ch3);
			*targ = ConvertFromHex(ch1)*16 + ConvertFromHex(ch2);

		}
	
		DboxPrintf(c.y, 4*c.x + A_FIELD_LNG + 1, "%c", ch2);
	
	
		LOOP:
		++c.CursorOffset;
		print_databox(content);
		UpdateControlStructure();
	}
	FINIT:
	c.mode = 0;
	print_headerbox();
}




void ReplaceACell(unsigned char *content)
{
	unsigned char ch1, ch2, ch3, EntryType;
	unsigned int i;
	unsigned char *targ = content + c.CursorOffset;

	ShowCursor();
	HboxPrintf(1, 46, "%s", "(s)tr, (h)ex or (d)ec replace:");
	do {
		EntryType = HboxGetChar(1, 77);
		if (EntryType == ESCAPE) { return; }
	} while (EntryType != 's' && EntryType != 'h' && EntryType != 'd');
	HideCursor();
	

	if      (EntryType == 's') c.mode = 4;
	else if (EntryType == 'h') c.mode = 5;
	else if (EntryType == 'd') c.mode = 6;
	print_headerbox();

	if (EntryType=='s') {

		while (1) {
			ch1 = DboxGetChar(c.y, 4*c.x + A_FIELD_LNG);
			if      (ch1 == ESCAPE) { goto END; }
			else if (isalnum(ch1))  { break;    }
		}
		*targ = ch1;

	} else if (EntryType=='d') {

		while (1) {
			ch1 = DboxGetChar(c.y, 4*c.x + A_FIELD_LNG);
			if      (ch1 == ESCAPE) { goto END;       }
			else if (isdigit(ch1))  { break;            }
		}
		DboxPrintf(c.y, 4*c.x + A_FIELD_LNG, "%c", ch1);
		while (1) {
			ch2 = DboxGetChar(c.y, 4*c.x + A_FIELD_LNG + 1);
			if      (ch2 == ESCAPE)  { goto END; }
			else if (isdigit(ch2))   { break;      }
			else if (ch2 == NEWLINE) { *targ = ch1-'0'; goto END; }
		}
		DboxPrintf(c.y, 4*c.x + A_FIELD_LNG + 1, "%c", ch2);
		while (1) {
			ch3 = DboxGetChar(c.y, 4*c.x + A_FIELD_LNG + 2);
			if      (ch3 == ESCAPE)  { goto END; }
			else if (isdigit(ch3))   { break;      }
			else if (ch3 == NEWLINE) { *targ = (ch1-'0')*10 + ch2-'0'; goto END; }
		}
		DboxPrintf(c.y, 4*c.x + A_FIELD_LNG + 2, "%c", ch3);
		i = (ch1-'0')*100 + (ch2-'0')*10 + ch3-'0';
		if (i < 256) *targ = i;

	} else if (EntryType == 'h') {

		while (1) {
			ch1 = DboxGetChar(c.y, 4*c.x + A_FIELD_LNG);
			if      (ch1 == ESCAPE)  { goto END; }
			else if (ch1 == NEWLINE) { goto END; }
			else if (isxdigit(ch1))  { break;    }
		}
		DboxPrintf(c.y, 4*c.x + A_FIELD_LNG, "%c", ch1);
		while (1) {
			ch2 = DboxGetChar(c.y, 4*c.x + A_FIELD_LNG + 1);
			if      (ch2 == ESCAPE)   { goto END; }
			else if (isxdigit(ch2))   { break;      }
			else if (ch2 == NEWLINE)  { *targ = ConvertFromHex(ch1); goto END; }
		}
		DboxPrintf(c.y, 4*c.x + A_FIELD_LNG + 2, "%c", ch3);
		*targ = ConvertFromHex(ch1)*16 + ConvertFromHex(ch2);

	}

	DboxPrintf(c.y, 4*c.x + A_FIELD_LNG + 1, "%c", ch2);

	END:
	c.mode = 0;
	print_headerbox();
}


/* Copy a character to the end of a string - like strcpy, but works on a */
/* character instead of a string.  Returns length of string.             */
int pstrcpy(char *dest, char src) {
   int len=strlen(dest);
   *(dest + len) = src;
   *(dest + len + 1) = '\0';
   return(len+1);
}



/* Just like the Perl function die */
int die(int exit_code, char *string) {
   printf("%s\n", string);
   exit(exit_code);
}


/* Just like fgets, but does not store the ending newline! */
int pgets(char *buffer, int size) {
   fgets(buffer, size, stdin);
   return(chomp(buffer));
}


/* Just like the Perl function chomp */
int chomp(char *string) {
   int size = strlen(string);
   *(string + size - 1) = '\0';
   return(size-1);
}
