/* 
*   @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@    @ = monitor boundary
*   @+----------------------------+@    - and +: drawn boundary
*   @|            hbox            |@
*   @+----------------------------+@    A_FIELD_LNG: length of offset field;
*   @ offset:   numeric   alpha    @       5 digits, 1 colon, 2 spaces
*   @            data      data    @    PER_LINE: # of addresses per line. is 3 
*   @                              @       in the example to the left
*   @ 00003:  99 89 10   F  ^T  a  @    HBOX_LINES: # of lines in hbox including
*   @ 00006:  60 DD A5   2   l  0  @       the border around the window.
*   @                              @      
*   @ dbox (doesn't include the    @      
*   @    drawn border around hbox) @
*   @                              @
*   @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
*/





#define CTL_L   12
#define NEWLINE 13
#define ESCAPE  27
#define F1 KEY_F(1)   /* Show help */
#define F2 KEY_F(2)   /* Toggle data type display */
#define F3 KEY_F(3)   /* Toggle offset type display */

#define VLINE ACS_VLINE
#define VLINE ACS_VLINE
#define HLINE ACS_HLINE
#define ULCORN ACS_ULCORNER
#define URCORN ACS_URCORNER
#define BLCORN ACS_LLCORNER     /* man pages are wrong, see man wborder */
#define BRCORN ACS_LRCORNER     /* man pages are wrong, see man wborder */

#define IBOXSZ 33
#define A_FIELD_LNG 8
#define PER_LINE 9
#define HBOX_LINES 4




typedef struct {
	/* Files Characteristics */
	int  filesize;      /* filesize of file we're editing                   */
	char filename[IBOXSZ];
	int  mode;   /* 0=command, 1=ascii search, 2=hex search, 3=dec search   */
                /* 4=str replace cell, 5=hex replace cell, 6=hex repl cell */

	/* Hbox and Program Characteristics */
	int d_format;      /* Dataformat:     0=decimal, 1=hex                  */
	int a_format;      /* Address format: 0=decimal, 1=hex                  */
	char inputbox[IBOXSZ];

	/* Dbox Characteristics */
	int Offset;        /* Offset of upper left corner dbox cell             */
	int LastOffset;    /* Last offset of upper left corner dbox cell        */
	int tot_dlines;    /* Number of data lines needed to print whole file   */
	int CellsPerPage;  /* Number of cells per page (addr of last page cell) */
	int last_x;        /* last x position (when top_ptr = last_top_ptr)     */
	int last_y;        /* last y position (when top_ptr = last_top_ptr)     */
	int LinesPerDbox;  /* Number of lines in dbox; 21 in console for me     */

	/* Cursor Characteristics */
	int y;             /* Cursor position wrt dbox upper left corner        */
	int x;             /* Cursor position wrt dbox upper left corner        */
	int InputX;        /* X position of the input cursor                    */
	int InputY;        /* Y position of the input cursor                    */
	unsigned int CursorOffset; /* Offset of current cursor position         */
} ctl;

/* main.c */
int main(int argc, char **argv);
void toprint(int arg, char *str, int strsize);

