#define _GNU_SOURCE   /* needed to get snprintf prototype */
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <fcntl.h>
#include "main.h"
#include "functions.h"

ctl c;

int main(int argc, char **argv) {

	/* necessary to separate curses from UI independent code */
	extern void user_interface(unsigned int *contents);

	unsigned int *contents;
	struct stat fstat;
	int fd;

	if (argc == 1) {
		printf("Enter file name: ");
		pgets(c.filename, 15);
	} else {
		snprintf(c.filename, 15, "%s", argv[1]);
	}

	
	/* Get the size of file in bytes */
	if ((fd = open(c.filename, O_RDONLY)) == -1)
		(void) die(1, "Can't open file.");	
	(void) stat(c.filename, &fstat);
	c.filesize = fstat.st_size;

	/* Allocate memory and read the file in */
	contents = calloc((size_t) c.filesize, 1);
	(void) read(fd, contents, (size_t)c.filesize);
	close(fd);

	c.d_format = 1;   /* Default is hex data      */
	c.a_format = 1;   /* Default is hex addresses */
	c.Offset   = 0;
	strncpy(c.inputbox, "Command Mode", IBOXSZ);

	user_interface(contents);
	
	free(contents);
	return(0);
}
