#include<stdio.h>
#include<curses.h>
#include"global.h"
#include"movement.h"

extern ctl c;


void JumpToEndOfFile(void) {
   c.Offset = c.CellsPerPage * (c.tot_dlines / c.LinesPerDbox);
	c.CursorOffset = c.Offset;
}

void JumpToOffset(int offset) {
	c.CursorOffset = offset;
	while (offset % PER_LINE != 0) --offset;
	c.Offset = offset;
}

void JumpToNextPage(void) {
	if (c.CursorOffset + c.CellsPerPage < c.filesize) {
		c.Offset += c.CellsPerPage;
		c.CursorOffset += c.CellsPerPage;
	} else {
		JumpToEndOfFile();
	}
}

void JumpToPreviousPage(void) {
	if (c.Offset > c.CellsPerPage) {
		c.Offset -= c.CellsPerPage;
		c.CursorOffset -= c.CellsPerPage;
	} else {
		c.Offset = c.CursorOffset = 0;
	}
}

void MoveCursorBackward(void) {
	if (c.CursorOffset <= 0) return;
	c.CursorOffset--;
	/* If we scroll off the page, we need to scroll the page up */
	if (c.CursorOffset < c.Offset) c.Offset -= PER_LINE;
}

void MoveCursorForward(void) {
	if (c.CursorOffset >= c.filesize - 1) return;
	c.CursorOffset++;
	/* If we scroll off the page, we need to scroll the page down */
	if (c.CursorOffset >= c.Offset + c.CellsPerPage) c.Offset += PER_LINE;
}

void MoveCursorToFrontOfLine(void) {
	while (c.CursorOffset % PER_LINE) c.CursorOffset--;
}

void MoveCursorToEndOfLine(void) {
	/* If we're at the beginning of a line, add PER_LINE to CursorOffset */
	if (c.CursorOffset % PER_LINE == 0) {
		c.CursorOffset += PER_LINE - 1;
		if (c.CursorOffset > c.filesize - 1) c.CursorOffset = c.filesize-1;
	} else {
		while (c.CursorOffset % PER_LINE) c.CursorOffset++;
		c.CursorOffset--;
	}
	if (c.CursorOffset > c.filesize - 1) c.CursorOffset = c.filesize-1;
}

void MoveCursorLineUp(void) {
	/* Don't go before the start of file */
	if (c.CursorOffset < PER_LINE ) {
		c.CursorOffset = 0;
	/* Scroll the databox if we're at the top of the databox */
	} else if (c.y == 0 && c.Offset !=0) {
		c.Offset -= PER_LINE;
		c.CursorOffset -= PER_LINE;
	/* No need to scroll, so simply move the cursor. */
	} else {
		c.CursorOffset -= PER_LINE;
	}
}


void MoveCursorLineDown(void) {
	/* Don't go past the end of file */
	if (c.CursorOffset + PER_LINE > c.filesize - 1 ) {
		c.CursorOffset = c.filesize - 1;
	/* Scroll the databox if we're at the bottom of the databox */
	} else if (c.y + 1 == c.LinesPerDbox) {
		c.Offset += PER_LINE;
		c.CursorOffset += PER_LINE;
	/* We might have scrolled, so we need to check EOF condition again */
	} else if (c.CursorOffset + PER_LINE < c.filesize ) {
		c.CursorOffset += PER_LINE;
	}
}



void GotoStartOfFile(void)
{
	c.Offset = c.CursorOffset = 0;
}
