#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include "hdr/global.h"
#include "hdr/routines.h"   /* for die */
#define  DICTIONARY /usr/share/dict/words

/************************************************************************* 
	Alpha parsing is rewriting a word in terms of occurances.  For example,
	THAT=ABCA, SCHOOL=ABCDDE and BEER=ABBC.

	*word is a pointer to the string to be alpha parsed.
	*target is a pointer to the string holding the alpha parse.
	*NonUniqueLetters is an array holding the unique letters found in *word.
	*Alphabet is an array holding the alphabet.

**************************************************************************/

int AlphaParse(GString *Word, GString *target)
{
	char NonUniqueLetters[26], Alphabet[26];
	char *WordPtr = Word->str;
	char *NonUniqueLettersPtr = NonUniqueLetters;
	gchar *AlreadyFound;
	int NextLetter = 'A', i;

	/* initialization */
	g_string_assign(target, "");
	for(i=0; i<26; i++) {
		*(NonUniqueLetters + i) = '\0';
		*(Alphabet + i)  = i + 'A';
	}

	while(*WordPtr) {
		AlreadyFound = strchr(NonUniqueLetters, *WordPtr);
		if (AlreadyFound) {
			/* We've seen *WordPtr already */
			for (i=0; i<26; i++) {
				if (*(NonUniqueLetters+i) == *AlreadyFound) break;
			}
			g_string_append_c(target, *(Alphabet + i));
		} else {
			/* *Word is a new unique letter */
			*(NonUniqueLettersPtr++) = *WordPtr;
			g_string_append_c(target,  NextLetter++);
		}
		WordPtr++;
	}

	printf("Word<%s>  Target<%s>  NonUnique<%s>\n",Word->str,target->str,NonUniqueLetters);

	return 0 ;
}


void DictionarySearch(GString *Target)
{
	FILE *FP;
	GString *Word, *TargetAlpha, *WordAlpha;
	GArray  *CandidateArray;
	gchar   string[INPUT_SZ];

	Word        = g_string_new("");
	WordAlpha   = g_string_new("");
	TargetAlpha = g_string_new("");
	CandidateArray = g_array_new(FALSE, FALSE, sizeof(GString *));

	/* Convert the target to an alpha parse */
	AlphaParse(Target, TargetAlpha);

	if ((FP = fopen("DICTIONARY", "r")) == NULL)
		die (1, "fopen error\n");
	
	while (fgets(string, INPUT_SZ - 1, FP) != NULL) {
		/* fgets reads till a \n or an EOF, but stores the newlines.  we'll
		 * convert them to \0
		 */
		g_strdelimit(string, "\n", '\0');
		/* Convert string to a GString and get its alpha parse. */
		g_string_assign(Word, string);
		AlphaParse(Word, WordAlpha);

		/* Case insensitive string comparison */
		if (! g_strcasecmp(WordAlpha->str, TargetAlpha->str))
			g_array_append_val(CandidateArray, Word);
	}

	/* At this point, we have all the alpha parse candidates */
	
}
