
%{

int word();
int number();
int garbage();

#define LC_AS		500
#define LC_BEGINNING	501
#define LC_BY		502
#define LC_CLEAR	503
#define LC_CONSONANT	504
#define LC_COPY		505
#define LC_CTL		506
#define LC_CTXT		507
#define LC_DOUBLE	508
#define LC_ENDING	509
#define LC_EXISTS	510
#define LC_FINAL	511
#define LC_FREQ		512
#define LC_IN		513
#define LC_INITIAL	514
#define LC_LETTERS	515
#define LC_MARK		516
#define LC_OTHERWISE	517
#define LC_PTXT		518
#define LC_PUT		519
#define LC_REMOVE	520
#define LC_RESTORE	521
#define LC_RULESET	522
#define LC_SAVE		523
#define LC_SHOW		524
#define LC_SORT		525
#define LC_SPACES	526
#define LC_STATE	527
#define LC_STRONG	528
#define LC_TO		529
#define LC_UNMARK	530
#define LC_VOWEL	531
#define LC_WEAK		532

#define LC_WORD		600
#define LC_NUMBER	601

#define LC_IS		700
#define LC_WHITESPACE	701
#define LC_NEWLINE	702
#define LC_EOF		703

%}

%option noyywrap

%%

"as"			{ return LC_AS; }
"beginning"		{ return LC_BEGINNING; }
"by"			{ return LC_BY; }
"clear"			{ return LC_CLEAR; }
"consonant"		{ return LC_CONSONANT; }
"copy"			{ return LC_COPY; }
"ctl"			{ return LC_CTL; }
"ctxt"			{ return LC_CTXT; }
"double"		{ return LC_DOUBLE; }
"ending"		{ return LC_ENDING; }
"exists"		{ return LC_EXISTS; }
"final"			{ return LC_FINAL; }
"freq"			{ return LC_FREQ; }
"in"			{ return LC_IN; }
"initial"		{ return LC_INITIAL; }
"letters"		{ return LC_LETTERS; }
"mark"			{ return LC_MARK; }
"otherwise"		{ return LC_OTHERWISE; }
"ptxt"			{ return LC_PTXT; }
"put"			{ return LC_PUT; }
"remove"		{ return LC_REMOVE; }
"restore"		{ return LC_RESTORE; }
"ruleset"		{ return LC_RULESET; }
"save"			{ return LC_SAVE; }
"show"			{ return LC_SHOW; }
"sort"			{ return LC_SORT; }
"spaces"		{ return LC_SPACES; }
"state"			{ return LC_STATE; }
"strong"		{ return LC_STRONG; }
"to"			{ return LC_TO; }
"unmark"		{ return LC_UNMARK; }
"vowel"			{ return LC_VOWEL; }
"weak"			{ return LC_WEAK; }

[A-Za-z]+		{ word();   return LC_WORD; }
[0-9]+			{ number(); return LC_NUMBER; }

\*			{ return '*'; }
\[			{ return '['; }
\]			{ return ']'; }
\.			{ return '.'; }
=			{ return '='; }

->			{ return LC_IS; }
[ \t]			{ return LC_WHITESPACE; }
[\r\n]			{ return LC_NEWLINE; }
<<EOF>>			{ yyterminate(); }

.+			{ garbage(); }

%%

int number()
{
	printf("number:  %s, %ld\n",yytext,atol(yytext));
}

int word()
{
	printf("word:  %s\n",yytext);
}

int garbage()
{
	printf("garbage %s\n",yytext);
}

/*
main()
{
	yylex();
}
*/
