%option noyywrap nounput

%{
#include <ctype.h>
#include <string.h>
#include "Parse.tab.h"
#include "hdr/global.h"

static int my_input( char *buffer, int max_size );

#undef  YY_INPUT
#define YY_INPUT( buffer, result, max_size ) { result = my_input( buffer, max_size ); }
%}

%%
[\t ]+                 ;                         /* ignore whitespace */
as                     ;                         /* convenience word */
to                     ;                         /* convenience word */
in                     ;                         /* convenience word */
->                     ;
=                      ;
\n                     return TOK_END;
\r                     return TOK_END;
clear                  return TOK_CLEAR;
copy                   return TOK_COPY;
dictionary             return TOK_DIC;
mark                   return TOK_MARK;
print                  return TOK_PRINT;
restore                return TOK_RESTORE;
save                   return TOK_SAVE;
ruleset                return TOK_RULESET;
set                    return TOK_SET;
show                   return TOK_SHOW;
sort[\t ]+by           return TOK_SORT;
unmark                 return TOK_UNMARK;
quit                   return TOK_QUIT;
\/                     return TOK_ALPHA;
vowel        |
   consonant |
   exact     |
   inexact             { yylval.string = strdup(yytext); return MARK; }
ctxt         |
   ptxt      |
   freq                { yylval.string = strdup(yytext); return SORT_TYPE; }
initial      |
   final     |
   all                 { yylval.string = strdup(yytext); return WIN2MODE; }
[a-zA-Z]               { yylval.character = yytext[0]; return LETTER;        }
[a-zA-Z0-9]{2,}        { yylval.string = strdup(yytext); return WORD;     }
[1-9]                  { yylval.number = atoi(yytext);   return NUMBER;   }
\*                     { yylval.number = 0; return NUMBER;                }
[a-zA-Z0-9]+           { return WORD;                                     }
%%

/* To be on the safe side copy only as many chars as there is room in the
   lexers buffer - the lexer will come back here if if it needs more... */

static int my_input( char *buffer, int max_size )
{
	int n = 0;
	static int remainder = 0;
	char *inp_str = Win3[ W3LEN - 1 ]->str + remainder;


	n = ( int ) strlen( inp_str );

	if ( n > max_size ) {
		remainder = n - max_size;
		n = max_size;
	} else {
  		remainder = 0;
	}

	memcpy( buffer, inp_str, n );
	return n;
}
