%{
#include <stdio.h>
#include <stdlib.h>
#include "hdr/MyParse.h"
#include "hdr/global.h"
#include "hdr/routines.h"
extern int yylex();

void yyerror(const char *string)
{
	pushWin3("Error: %s.", string);
}

%}

%token TOK_CLEAR TOK_COPY TOK_MARK TOK_PRINT TOK_RESTORE TOK_RULESET TOK_SAVE
%token TOK_SHOW TOK_SORT TOK_UNMARK TOK_QUIT WIN2MODE SORT_TYPE 
%token TOK_DIC TOK_SET TOK_ALPHA TOK_END

%union
{
	int  number;
	char *string;
	char character;
}

%token <number>    NUMBER
%token <character> LETTER
%token <string>    WORD
%token <string>    MARK
%token <string>    SORT_TYPE
%token <string>    WIN2MODE

%%

commands: /* empty */
	| commands command
	;

command:
	dictionary
	|
	LetAssign
	|
	clear
	|
	copy
	|
	ruleset
	|
	WordAssign
	|
	mark
	|
	unmark
	|
	TOK_SAVE WORD TOK_END      { SaveState($2); }
	|
	TOK_RESTORE WORD TOK_END   { RestoreState($2); }
	|
  	TOK_QUIT                   { StillGoing = FALSE; }
	|
	TOK_PRINT TOK_END          { PrintScreen(); }
	|
	TOK_SORT SORT_TYPE TOK_END { Win2Sort($2); }
	|
	TOK_SHOW WIN2MODE TOK_END  { ChangeWin2Mode($2); }
	|
	TOK_ALPHA WORD TOK_END     { FindAlphaParse($2); }
	;

WordAssign: WORD WORD TOK_END                     { WordAssign($2, $1, -1);  }
	|        WORD WORD NUMBER TOK_END              { WordAssign($2, $1, $3);  }
	|        LETTER LETTER TOK_END                 { Assign($2, $1, -1);      }
	|        LETTER LETTER NUMBER TOK_END          { Assign($2, $1, $3);      }
	;
LetAssign:  LETTER LETTER NUMBER TOK_END          { Assign($1, $2, $3);      }
	|        LETTER LETTER TOK_END                 { Assign($1, $2, Ruleset); }
	;
clear:      TOK_CLEAR NUMBER TOK_END              { ClearRuleset($2);        }
	|        TOK_CLEAR TOK_END                     { ClearRuleset(Ruleset);   }
	;
ruleset:    TOK_RULESET NUMBER TOK_END            { ChangeRuleset($2);       }
	|        TOK_RULESET TOK_END                   { ChangeRuleset(-1);       }
	;
copy:       TOK_COPY NUMBER        NUMBER TOK_END { CopyRuleset($2, $3);     }
   |        TOK_COPY NUMBER NUMBER TOK_END        { CopyRuleset($2, $2);     }
	|        TOK_COPY NUMBER TOK_END               { CopyRuleset(-1, $2);     }
	;
mark:       TOK_MARK LETTER MARK TOK_END          { Mark($2, $3, Ruleset);   }
   |        TOK_MARK LETTER MARK NUMBER TOK_END   { Mark($2, $3, $4);        }
	;
unmark:     TOK_UNMARK LETTER TOK_END             { UnMark($2, Ruleset);     }
   |        TOK_UNMARK LETTER NUMBER TOK_END      { UnMark($2, $3);          }
	;
dictionary: TOK_SET TOK_DIC WORD TOK_END          { SetDictionary($3);       }
	;
%%

