#define _GNU_SOURCE
#include <ctype.h>
#include <glib.h>
#include <string.h>
#include "hdr/UIcurses.h"
#include "hdr/global.h"
#include "hdr/MyParse.h"
#include "hdr/routines.h"
#include "hdr/initialize.h"
#include "Parse.tab.h"
#define ISVALIDCHAR(c) (isalnum(c) || ispunct(c) || isblank(c))
extern int yyparse();
extern GString *RawCipherText;
extern gboolean StillGoing;




void ncurses_main(LetterStruct letlist[], control ctl)
{
	/* w1=main window  w2=rule/freq window  w3=I/O */
	WINDOW *w1, *w2, *w3;
	StillGoing = TRUE;

	init_curses(&w1, &w2, &w3);

	if (RestoredState == FALSE) text_input(w1, w3, letlist);

	frequency(letlist, &ctl);

	draw_window_borders(w1, w2, w3);
	draw_win1(w1, letlist);
	SetupWin2(letlist, &ctl);

	/* MAIN EVENT LOOP */
	while(StillGoing == TRUE) {
		draw_win1(w1, letlist);
		SetupWin2(letlist, &ctl);
		draw_win2(w2, letlist, ctl);
		draw_win3(w3);
		GetWin3Input(w3);	
		yyparse();
	}

	finishup(w1, w2, w3);

}



void draw_win1(WINDOW *w1, LetterStruct letlist[]) {
	register signed int x, y;
	register unsigned int i;
	int index, letter, mask;

	/* Clear the text area */
	for (y=1; y<LINES-W3LEN-2; ++y)
		for (x=1; x<COLS-16; ++x) {
			mvwaddch(w1, y, x, ' ');
	}

	for(i=0, y=1, x=1; i < (unsigned) RawCipherText->len; ++i, ++x) {
		letter = RawCipherText->str[i];
		index = (int) (letter - 'A');
		mask = letlist[index].mask[Ruleset];

		if (x==63) {
			while (RawCipherText->str[i] != ' ' || x==2) {
				--i; --x;
				mvwaddch(w1, y, x, ' ');
				mvwaddch(w1, y+1, x, ' ');
			}
			y += 3; x = 0;
			continue;
		}

		/* If we have color and the letter has a mask, set an attribute */
		if(isalpha(letter) && has_colors() && mask != ' ') {
			switch(letlist[letter-'A'].mask[Ruleset]) {
				case VOWEL:     wattron(w1, COLOR_PAIR(COLOR_RED));   break;
				case CONSONANT: wattron(w1, COLOR_PAIR(COLOR_GREEN)); break;
				case EXACT:     wattron(w1, A_BOLD);                  break;
				case INEXACT:   wattron(w1, A_DIM);                   break;
			}
		}
		mvwaddch(w1, y, x, letter);

		/* Draw what's underneath the letter */
		if (isspace(letter) || ispunct(letter)) {
			/* Always draw ptxt punctuation and space */
			mvwaddch(w1, y+1, x, letter);
		} else if (letlist[index].rule[Ruleset] == ' ') {
			/* We have no ptxt for this ctxt under this rule */
			mvwaddch(w1, y+1, x, '_');
		} else {
			/* We do have ptxt for this ctxt under this rule */
			mvwaddch(w1, y+1, x, letlist[index].rule[Ruleset]);
		}
		wattrset(w1,0);     /* Turn mask color off */
	}/*end for*/

	wmove(w1, y, x);
	wrefresh(w1);
}




/*************************************************************************/
/* For now we simply ignore the sort.  Soon we'll sort the stuff out     */
/* according to ctext alpha, ptext alpha and frequency.  For now, every  */
/* sort is sort 1. sort=0 (ctext alpha) sort=1 (freq) sort=2(ptex alpha) */
/*************************************************************************/
void draw_win2(WINDOW *w, LetterStruct l[], control ctl)
{
	int i;
	int rule = Ruleset;

	mvwprintw(w, 1, 3, "Ruleset  #%d", rule);
	switch(Win2Mode) {
		case 0: mvwprintw(w, 2, 2, " Letter Freq "); break;
		case 1: mvwprintw(w, 2, 2, "Initial  Freq"); break;
		case 2: mvwprintw(w, 2, 2, " Final  Freq "); break;
	}
		
	for(i=0; i<13; i++) {
		switch(l[ctl.win2[i][0] -'A'].mask[rule]) {
			case 'V': wattron(w, COLOR_PAIR(COLOR_RED));   break;
			case 'C': wattron(w, COLOR_PAIR(COLOR_GREEN)); break;
			case 'E': wattron(w, A_BOLD);                  break;
			case 'W': wattron(w, A_DIM);                   break;
		}
		mvwprintw(w, i+4, 1, "%s", ctl.win2[i]);
		/* Turn mask colour off */
		wattrset(w, 0);
	}

	for(i=13; i<=25; i++) {
		switch(l[ctl.win2[i][0] -'A'].mask[rule]) {
			case 'V': wattron(w, COLOR_PAIR(COLOR_RED));   break;
			case 'C': wattron(w, COLOR_PAIR(COLOR_GREEN)); break;
			case 'E': wattron(w, A_BOLD);                  break;
			case 'W': wattron(w, A_DIM);                   break;
		}
		mvwprintw(w, i-9, 9, "%s", ctl.win2[i]);
		wattrset(w, 0); /* Turn mask colour off */
	}

   wrefresh(w);
}




void draw_win3(WINDOW *w3) {
	register int i, y, x;

	getyx(w3, y, x);
	wclear(w3);
	for (i=W3LEN-1; i>=0; i--)
		mvwprintw(w3, i, 0, "%s", Win3[i]->str);

	wmove(w3, y, x);
	wrefresh(w3);
}




/*
 *  Gets user input from window 3
 */
void GetWin3Input(WINDOW *w3) {
	register char c;
	char *LastWord;
	GString *input = Win3[W3LEN-1];   /* input is only an abbreviation */

	g_string_assign(input, "> ");
	wmove(w3, W3LEN-1, 2);
	draw_win3(w3);

	while((c=wgetch(w3)) != NEWLINE) {
		if ((c == XBCKSPC || c == CBCKSPC) && input->len > 2) {
			g_string_truncate(input, input->len - 1);
		} else if (c == CONTROL_U) {
			g_string_assign(input, "> ");
		} else if (c == CONTROL_W && input->len>0) {
			LastWord = rindex(input->str, ' ');
			if (LastWord != index(input->str, ' ')) {
				g_string_truncate(input, input->len - strlen(LastWord));
			} else {
				g_string_assign(input, "> ");
			}
		} else if (c == TAB && input->len > 0) {
			TabComplete(input);
		} else if( ISVALIDCHAR(c) && input->len < INPUT_SZ && c != TAB ) {
			g_string_append_c(input, c);
		}
		wmove(w3, W3LEN-1, input->len);
		draw_win3(w3);
	}
	/* bison needs a trailing newline */
	g_string_append_c(input, '\n');

	draw_win3(w3);

}




void finishup(WINDOW *w1, WINDOW *w2, WINDOW *w3)
{
	register int i;

	wclear(w1); wrefresh(w1); delwin(w1);
	wclear(w2); wrefresh(w2); delwin(w2);
	wclear(w3); wrefresh(w3); delwin(w3);
	endwin();
}




/* This routine must be called before any references to the   */
/* windows are made.                                          */

void init_curses(WINDOW **w1, WINDOW **w2, WINDOW **w3)
{
	initscr();                  /* initialize curses library */
	if (has_colors()) {         /* color initialization      */
		start_color();
      init_pair(COLOR_BLACK,   COLOR_BLACK,   COLOR_BLACK);
      init_pair(COLOR_RED,     COLOR_RED,     COLOR_BLACK);
		init_pair(COLOR_GREEN,   COLOR_GREEN,   COLOR_BLACK);
      init_pair(COLOR_YELLOW,  COLOR_YELLOW,  COLOR_BLACK);
      init_pair(COLOR_BLUE,    COLOR_BLUE,    COLOR_BLACK);
      init_pair(COLOR_MAGENTA, COLOR_MAGENTA, COLOR_BLACK);
      init_pair(COLOR_CYAN,    COLOR_CYAN,    COLOR_BLACK);
      init_pair(COLOR_WHITE,   COLOR_WHITE,   COLOR_BLACK);
	}
	keypad(stdscr,TRUE);
	nonl();              /* don't translate \n to \r\n */
	cbreak();            /* input is uncooked (raw)    */
	noecho();            /* don't echo input           */

	/***********************************************************/
	/* Initialize the windows (they're not drawn yet).         */
	/***********************************************************/
	*w1 = newwin(LINES-W3LEN, COLS-17, 0,           0);
	*w2 = newwin(LINES-W3LEN, 17,      0,           COLS-17);
	*w3 = newwin(W3LEN,       COLS,    LINES-W3LEN, 0);
	/* *p1 = new_panel(*w1);
	*p2 = new_panel(*w1); */
	if (*w1==NULL) die(1, "Error: Couldn't get a pointer to w1.");
	if (*w2==NULL) die(2, "Error: Couldn't get a pointer to w2.");
   if (*w3==NULL) die(3, "Error: Couldn't get a pointer to w3.");
/*	if (*p1==NULL) die(4, "Error: Couldn't get a pointer to p1.");
	if (*p2==NULL) die(5, "Error: Couldn't get a pointer to p2.");
	hide_panel(*p2);
	show_panel(*p1); */
}





/*************************************************************************/
/* This function paints all the rules, tees and corners.  COLS=80        */
/*************************************************************************/
void draw_window_borders(WINDOW *w1, WINDOW *w2, WINDOW *w3) {
	int W1LEN = LINES - W3LEN - 1;

	/* WINDOW 1 */
	werase(w1);
	mvwhline(w1, 0,     0, ACS_HLINE,     COLS-17);   /* top horiz border   */
	mvwhline(w1, W1LEN, 0, ACS_HLINE,     COLS-17);   /* botom horiz border */
	mvwvline(w1, 1,     0, ACS_VLINE,     W1LEN-1);   /* Left vertical rule */
	mvwaddch(w1, 0,     0, ACS_ULCORNER);             /* Upper left corner  */
	mvwaddch(w1, W1LEN, 0, ACS_LLCORNER);             /* Bottom left corner */
	/* WINDOW 2 */
	werase(w2);
	mvwhline(w2, 0,     0,       ACS_HLINE, 16);      /* Top horiz rule     */
	mvwhline(w2, 3,     0,       ACS_HLINE, 16);      /* Middle horiz rule  */
	mvwhline(w2, W1LEN, 0,       ACS_HLINE, 16);      /* Bottom horiz rule  */
	mvwvline(w2, 1,     0,       ACS_VLINE, W1LEN-1); /* Left vert rule     */
	mvwvline(w2, 4,     8,       ACS_VLINE, W1LEN-4); /* Middle vert rule   */
	mvwvline(w2, 1,     COLS-64, ACS_VLINE, W1LEN-1); /* Right vert rule    */
	mvwaddch(w2, 3,     0,       ACS_LTEE);           /* Middle left tee    */
	mvwaddch(w2, 3,     8,       ACS_TTEE);           /* Upper middle tee  */
	mvwaddch(w2, W1LEN, 8,       ACS_BTEE);           /* Lower  middle tee  */
	mvwaddch(w2, 0,     COLS-64, ACS_URCORNER);       /* Upper right Corner */
	mvwaddch(w2, 3,     COLS-64, ACS_RTEE);           /* Middle right tee   */
	mvwaddch(w2, W1LEN, COLS-64, ACS_LRCORNER);       /* Lower right Corner */
	mvwaddch(w2, 0,     0,       ACS_TTEE);           /* Upper left Corner  */
	mvwaddch(w2, W1LEN, 0,       ACS_BTEE);     /* Upper left Corner  */
	/* WINDOW 3 */
	werase(w3);

	wrefresh(w1);
	wrefresh(w2);
	wrefresh(w3);
}




/*  Get's user's input for the ctxt in window 1 at start of program if we
 *  don't start the program by reading ctxt from a file.  The line wrapping
 *  mechanism barfs if a word is longer than the length of win1.  So we use
 *  the variable wordlength to make sure no word is more than 30 characters.
 */
void text_input(WINDOW *w1, WINDOW *w3, LetterStruct letlist[])
{
	int i=0, wordlength=0;
	char ch;
	/* How many last chars are space?  Start at 2 to prevent initial space */
	int wasSpace = 2;


	mvwprintw(w3, 2, 7, "Enter your cipher. Press <ENTER> when done.");
	wmove(w1, 1, 1);
	wrefresh(w3);

	while ( i < CTXT_SZ - 1) {
		ch = (char) toupper(wgetch(w1));

		if (ch == ' ' && wasSpace < 2) {
			g_string_append_c(RawCipherText, ch);
			wordlength=0;
			++wasSpace;
		} else if (ch==NEWLINE) {
			break;
		} else if (ch == XBCKSPC || ch == CBCKSPC) {
			g_string_truncate(RawCipherText, RawCipherText->len - 1);
			--wordlength;
		} else if (ISCHAR(ch) && ch != TAB && wordlength<30) {
			g_string_append_c(RawCipherText, ch);
			++wordlength;
			wasSpace = 0;
		}
		draw_win1(w1, letlist);
	}
}
