#ifndef GLOBAL_H
#define GLOBAL_H

#define PROGRAM "linux-crypt"
#define VERSION "0.6.1beta"

#define BEEP          7
#define XBCKSPC       8
#define TAB           9
#define NEWLINE      13
#define CONTROL_U    21
#define CONTROL_W    23
#define CHARS        26
#define CBCKSPC     127

#define CTXT_SZ 400
#define PARSE_SZ 12
#define INPUT_SZ 80
#define MAXWORDS  30
#define W3LEN     6
#define WORDSIZE  15
#define ISCHAR(c)          (isalpha(c) || ispunct(c))
#include <gtk/gtk.h>       /* For GString definition */

/* For win2mode */
#define SHOW_FREQ         0
#define SHOW_INITIAL_FREQ 1
#define SHOW_ENDING_FREQ  2

/* For sort */
#define BY_CIPHERTEXT 0
#define BY_FREQUENCY  1
#define BY_PLAINTEXT  2

/* For marking */
#define VOWEL     0
#define CONSONANT 1
#define EXACT     2
#define INEXACT   3

typedef struct {
	GString *dictionary;
	char win2[26][9];                /* contents of win2 plus null        */
	char words[MAXWORDS][WORDSIZE];  /* words (without punctuation)       */
} control;



/* There's one of these for each letter of the alphabet, number 0 to 25. */
/* mask: v=vowel, c=consonant, e=exact, i=inexact                        */
typedef struct {
	char clet;
	char rule[10];      /* 0 is unused */
	char mask[10];      /* 0 is unused */
	int  Freq;          /* frequency */
	int  InitialFreq;   /* initial frequency */
	int  EndingFreq;    /* final frequency */
} LetterStruct;

gboolean     RestoredState;
GString      *RawCipherText;        /* Raw Cipher Text                   */
GString      *Win3[W3LEN];          /* contents of win3; 0=current 5=old */
int          Ruleset;               /* The current ruleset               */
unsigned     int NumberOfWords;     /* number of words                   */
unsigned     int Sort;              /* 0=ctxt alpha, 1=freq 2=ptxt alpha */
unsigned     int Win2Mode;          /* 0=freq, 1=initial 2=final         */
LetterStruct Letter[CHARS];
control      ctl;
gboolean     StillGoing;
#endif
