#define _GNU_SOURCE
#include <stdio.h>       /* fopen and friends */
#include <ctype.h>
#include "hdr/routines.h"
#include "hdr/global.h"

void initialize_structs(LetterStruct letlist[], control *ctl) {
	register int i, u;

	RawCipherText = g_string_new("");
	Ruleset       = 1;
	NumberOfWords = 1;
	Sort          = BY_CIPHERTEXT;
	Win2Mode      = SHOW_FREQ;
	RestoredState = FALSE;

	ctl->dictionary = g_string_new("/usr/share/dict/words");

   /* Initialize the ctl structure */
	for(i=0; i<26; i++) strcpy(ctl->win2[i], "");

	for(i=0; i<W3LEN; ++i) {
		Win3[i] = g_string_new("");
	}

   /* Initialize the letlist structure */
	for(i = 0; i < 26; i++) {
		letlist[i].clet = (char) ((int) 'A' + i);
		letlist[i].Freq = 0;		
		letlist[i].InitialFreq = 0;		
		letlist[i].EndingFreq = 0;		
		for(u=0; u<10; u++) {
			letlist[i].rule[u] = ' ';
			letlist[i].mask[u] = ' '; /* vowel, consonant, exact, weak */
		}
	}/*end for*/
}




/*  This function gets cipher input from a text file.  It discards newlines
 *  and stores the remaining string in ctl.  The integer returned controls
 *  whether main exits, or whether  startup asks for user cipher input.
 */
void file_input(char *file)
{
	int ch;
	FILE *fp;

	if((fp = fopen(file, "r")) == NULL) die(1, "file_input: Can't open file.");

	while((ch = fgetc(fp)) != EOF) {
		if (! isascii(ch) && ! isblank) {
			die(2, "Oops: Loading in a non-ascii file.");
		} else if (RawCipherText->len >= CTXT_SZ) {
			die(3, "Oops: Cipher file is too long.");
		} else {
			if (ch == NEWLINE || ch == TAB)
				ch = ' ';
	 		g_string_append_c(RawCipherText, (char)toupper((int)ch));
		}
	}
	fclose(fp);
}




void frequency(LetterStruct letlist[], control *ctl) {
	register unsigned int i=0, u=0;
	int first, last;
	gchar *ptr = RawCipherText->str;


	/* Break RawCipherText up into words */
	while(*ptr) {
		if (*ptr == ' ') {
			ctl->words[NumberOfWords-1][i] = '\0';
			++NumberOfWords;
			i=0;
		} else if (ispunct(*ptr) || isdigit(*ptr)) {
			/* do nothing */
		} else {
			ctl->words[NumberOfWords-1][i] = *ptr;
			++i;
		}
		++ptr;
	}
	ctl->words[NumberOfWords-1][i] = '\0';

	/* Generate First and Last word frequencies */
	for (i=0; i<NumberOfWords; ++i) {
		first = toupper(ctl->words[i][0]) - 'A';
		letlist[first].InitialFreq += 1;
		last  = toupper(ctl->words[i][strlen(ctl->words[i])-1]) - 'A';
		letlist[last].EndingFreq += 1;
	}

	ptr = RawCipherText->str;
	while(*ptr) {
		/* change the array that was passed to upper-case letters  */
		/* As long as we're not punct or space, convert ctxt to an */
		/* int and increment the frequency array.                  */
		if(*ptr >= 'A' && *ptr <= 'Z') {
			u = (int) *ptr - (int) 'A';
			(letlist[u]).Freq += 1;
		}
		++ptr;
	}
}	


