#include <getopt.h>
#include "hdr/global.h"
#include "hdr/UIcurses.h"
#include "hdr/routines.h"
#include "hdr/initialize.h"
#include "hdr/MyParse.h"

int main(int argc, char *argv[])
{
	gboolean UseGTK = FALSE;
	int i, opt;

	static struct option longopts[] = {
		{"read",    1, NULL, 'r'},
		{"restore", 1, NULL, 'R'},
		{"version", 0, NULL, 'V'},
		{"gtk",     0, NULL, 'g'},
		{NULL,      0, NULL, 0  }
	};



	initialize_structs(Letter, &ctl);

	while ((opt = getopt_long(argc, argv, "gVR:r:", longopts, NULL)) != EOF) {
      switch (opt) {
		case 'g': UseGTK = TRUE;        break;
		case 'V': version();            break;
		case 'R': RestoreState(optarg); break;
		case 'r': file_input(optarg);   break;
		}
	}


	if (UseGTK == TRUE && gtk_init_check(&argc, &argv) == FALSE)
		die(1, "I can't initialize gtk.  Bailing.\n");

	if (UseGTK == FALSE)
		ncurses_main(Letter, ctl);
	else
		printf("gtk hasn't been implemented yet.\n");

	g_string_free(RawCipherText, TRUE);
	for (i=0; i<W3LEN; ++i)
		g_string_free(Win3[i], TRUE);


	return 0;
}
