#define _GNU_SOURCE
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include "hdr/global.h"
#include "hdr/routines.h"


void pushWin3(char *fmt, ...) {
	va_list arg_ptr;
	char character, *p, *s, *ptr=Win3[5]->str;
	int integer;

	/* Make room for message in win3[W3LEN] by shifting win3 */
	shiftWin3();

	va_start(arg_ptr, fmt);

   /* Process fmt, character by character */
   for (p=fmt; *p; ++p) {
      if (*p != '%') {
         g_string_append_c(Win3[5], *p);
         continue;
      }
      switch(*++p) {
         case 's':
				s = va_arg(arg_ptr, char *);
				g_string_append(Win3[5], s);
            ptr += strlen(s);
				break;
			case 'd':
				integer = va_arg(arg_ptr, int);
				g_string_sprintfa(Win3[5], "%d", integer);
				++ptr;
				break;
			case 'c':
				character = va_arg(arg_ptr, char);
				g_string_append_c(Win3[5], character);
				++ptr;
				break;
      }
   }
   va_end(arg_ptr);
	shiftWin3();
	shiftWin3();
}



void shiftWin3() {
	/* Win3[0]=oldest  Win3[W3LEN]=current */
	register int i;
   for (i=0; i<W3LEN - 1; i++)
		g_string_assign(Win3[i], Win3[i+1]->str);

	/* Empty out the last line */
	g_string_truncate(Win3[W3LEN-1], 0);
}



void version(void) {
   printf("%s v.%s by Peter Jay Salzman and Rhonda Frances ",PROGRAM,VERSION);
   printf("Bailey\n");
   printf("  Copyright 1999 Peter Jay Salzman. <p@dirac.org>\n");
   printf("  Thanks:   Rhonda Frances Bailey   <rfbailey@ucdavis.edu>\n");
   printf("            Jeff Newmiller          <jeffn@endecon.com>\n");
   printf("  Released under the GNU GPL license.\n");
   printf("  Linux! ...  and there was much rejoicing!  Oyeeeeh...\n");
   exit(0);
}


void die(int exit_code, char *string) {
   printf("%s\n", string);
   exit(exit_code);
}



void TabComplete(GString *input) {
   char cmd[][INPUT_SZ] = {
   "-> ", "as ", "by ", "clear", "copy ", "consonant", "ctxt", "exact", "in",
	"inexact", "initial", "final", "freq", "letter", "mark ", "print ", "ptxt",
	"quit", "restore ", "ruleset ", "save ", "screen", "show", "sort ",
	"state ", "unmark", "vowel", "" };
	gboolean    FoundMatch=TRUE;
	static int  NumberOfMatches, LastCmdUsed;
	int         j=0, i=0;
	static GString *Candidates[20]; /* FIXME magic number */
	char        *LastWordPtr;
	static      GString *CompletedWord = NULL;
	GString     *ToBeCompleted;

	if (CompletedWord == NULL) {
		CompletedWord = g_string_new(NULL);
		for (i=0; i<20; ++i)
			Candidates[i] = g_string_new(NULL);
	}

	ToBeCompleted = g_string_new(NULL);

	/* Find last word */
	LastWordPtr = rindex(input->str, ' ');
	if (LastWordPtr == NULL)      /* We're completing 1st word of input */
		LastWordPtr = input->str;
	else
		++LastWordPtr;


	if (*LastWordPtr == '\0') {
		do {
			LastWordPtr--;
		} while (*LastWordPtr == ' ');
		do {
			LastWordPtr--;
		} while (LastWordPtr != input->str && *LastWordPtr != ' ');

		if (LastWordPtr != input->str) ++LastWordPtr;
	}

	g_string_append(ToBeCompleted, LastWordPtr);


	if (! strcmp(ToBeCompleted->str, CompletedWord->str)) {
		/* User previously tried completing a word and we completed the wrong one.
		 * They pressed TAB again, so pick the next item on the Candidates list.
	 	 */
		if (++LastCmdUsed >= NumberOfMatches) LastCmdUsed = 0;

	} else {

		/* Reset variable holding the last returned command */
		LastCmdUsed = 0;
		NumberOfMatches = 0;

		/* Build up a list of candidates to be completed */
		i = 0;
		while(strcmp(cmd[i], "")) {

			/* If ToBeCompleted is larger than cmd[i], throw cmd[i] out */
			while ((unsigned)ToBeCompleted->len > strlen(cmd[i])) {
				i++;
			}

			/* Test if cmd[i] could be a completion */
			for(j=0, FoundMatch=TRUE; j < ToBeCompleted->len; j++) {
				if ( *(ToBeCompleted->str +j) != cmd[i][j])
					FoundMatch = FALSE;
			}

			/* We found a match - copy the candidate word into Candidates array */
			if (FoundMatch==TRUE)
				g_string_assign(Candidates[NumberOfMatches++], cmd[i]);

			++i;
		}
	}

	if (! NumberOfMatches) return;
	/* Shave off the yet-to-be-completed word, and append completed word */
	g_string_truncate(input, input->len - ToBeCompleted->len);
	g_string_append(input, Candidates[LastCmdUsed]->str);

	/* Keep a copy of completed word.  If it's the wrong one, they'll press TAB
	 * again, and we'll compare the new last word with the one we just completed.
	 */
	g_string_assign(CompletedWord, Candidates[LastCmdUsed]->str);

	g_string_free(ToBeCompleted, TRUE);
}





void SetupWin2(LetterStruct l[], control *ctl) {
	register int i, j, frq;
	int temp;
	int freq[26];
	char ctxt[26], ptxt[26];

	/* Determine if we're going to sort the frequency chart by frequency,
	 * initial frequency or ending frequency
	 */
	for(i=0; i<26; i++) {
		switch(Win2Mode) {
			case SHOW_FREQ:         freq[i] = l[i].Freq;        break;
			case SHOW_INITIAL_FREQ: freq[i] = l[i].InitialFreq; break;
			case SHOW_ENDING_FREQ:  freq[i] = l[i].EndingFreq;  break;
		}
	}

	/* Show rules from whatever ruleset we're currently in */
	for(i = 0; i < 26; i++) {
		ctxt[i] = 'A' + i;
		ptxt[i] = l[i].rule[Ruleset];
	}

	/* Sort by cipher text, alphabetically */
	if (Sort == BY_CIPHERTEXT) {
		for (i=0; i<26; i++)
			snprintf(ctl->win2[i], 9,"%c->%c %2d", ctxt[i], ptxt[i], freq[i]);
	}

	/* Sort by frequency */
	if (Sort == BY_FREQUENCY) {
		for(j = 0; j < 26; j++){
			for(i = j+1; i< 26; i++){
				if(freq[j] < freq[i]){
					frq = freq[j];
					freq[j] = freq[i];
					freq[i] = frq;
					temp = ctxt[j];
					ctxt[j] = ctxt[i];
					ctxt[i] = temp;
					temp = ptxt[j];
					ptxt[j] = ptxt[i];
					ptxt[i] = temp;
				}
			}
		}
		for (i=0; i<26; i++)
			snprintf(ctl->win2[i], 9,"%c->%c  %d", ctxt[i], ptxt[i], freq[i]);
	}

	/* Sort by plain text, alphabetically */
	if(Sort == BY_PLAINTEXT) {
		for(j = 0; j < 26; j++){
			for(i = j+1; i< 26; i++){
				if((ptxt[j] > ptxt[i] && ptxt[i]!=' ') || ptxt[j] == ' '){
					frq = freq[j];
					freq[j] = freq[i];
					freq[i] = frq;
					temp = ctxt[j];
					ctxt[j] = ctxt[i];
					ctxt[i] = temp;
					temp = ptxt[j];
					ptxt[j] = ptxt[i];
					ptxt[i] = temp;
				}
			}
		}
		for (i=0; i<26; i++)
			snprintf(ctl->win2[i], 9,"%c->%c  %d", ctxt[i], ptxt[i], freq[i]);
	}
}




/************************************************************************* 
	Alpha parsing is rewriting a word in terms of occurances.  For example,
	THAT=ABCA, SCHOOL=ABCDDE and BEER=ABBC.

	*word is a pointer to the string to be alpha parsed.
	*target is a pointer to the string holding the alpha parse.
	*NonUniqueLetters is an array holding the unique letters found in *word.
	*Alphabet is an array holding the alphabet.

**************************************************************************/

int AlphaParse(GString *Word, GString *target)
{
	char NonUniqueLetters[26], Alphabet[26];
	char *WordPtr = Word->str;
	char *NonUniqueLettersPtr = NonUniqueLetters;
	gchar *AlreadyFound;
	int NextLetter = 'A', i;

	/* initialization */
	g_string_assign(target, "");
	for(i=0; i<26; i++) {
		*(NonUniqueLetters + i) = '\0';
		*(Alphabet + i)  = i + 'A';
	}

	while(*WordPtr) {
		AlreadyFound = strchr(NonUniqueLetters, *WordPtr);
		if (AlreadyFound) {
			/* We've seen *WordPtr already */
			for (i=0; i<26; i++) {
				if (*(NonUniqueLetters+i) == *AlreadyFound) break;
			}
			g_string_append_c(target, *(Alphabet + i));
		} else {
			/* *Word is a new unique letter */
			*(NonUniqueLettersPtr++) = *WordPtr;
			g_string_append_c(target,  NextLetter++);
		}
		WordPtr++;
	}

	/*
	printf("Word<%s>  Target<%s>  NonUnique<%s>\n",
		Word->str, target->str, NonUniqueLetters);
	*/

	return 0 ;
}
